/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block.entity;

import com.google.common.collect.Lists;
import com.voxelutopia.ultramarine.data.recipe.CompositeSmeltingRecipe;
import com.voxelutopia.ultramarine.data.registry.BlockEntityRegistry;
import com.voxelutopia.ultramarine.data.registry.RecipeTypeRegistry;
import com.voxelutopia.ultramarine.world.block.menu.BrickKilnMenu;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BrickKilnBlockEntity
extends BlockEntity
implements MenuProvider,
RecipeHolder {
    public static final int SLOT_INPUT_PRIMARY = 0;
    public static final int SLOT_INPUT_SECONDARY = 1;
    public static final int SLOT_FUEL = 2;
    public static final int SLOT_RESULT = 3;
    public static final int DATA_LIT_TIME = 0;
    public static final int DATA_LIT_DURATION = 1;
    public static final int DATA_COOKING_PROGRESS = 2;
    public static final int DATA_COOKING_TOTAL_TIME = 3;
    public static final int NUM_DATA_VALUES = 4;
    public static final int NUM_SLOTS = 4;
    public static final int BURN_TIME_STANDARD = 200;
    public static final int BURN_COOL_SPEED = 2;
    private static final Component CONTAINER_TITLE = Component.m_237115_((String)"container.brick_kiln");
    int litTime;
    int litDuration;
    int cookingProgress;
    int cookingTotalTime;
    private final ItemStackHandler ingredientsHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            BrickKilnBlockEntity.this.m_6596_();
        }
    };
    private final ItemStackHandler fuelHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            BrickKilnBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0;
        }
    };
    private final ItemStackHandler resultHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            BrickKilnBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    };
    private LazyOptional<ItemStackHandler> ingredientsLazyHandler = LazyOptional.empty();
    private LazyOptional<ItemStackHandler> fuelLazyHandler = LazyOptional.empty();
    private LazyOptional<ItemStackHandler> resultLazyHandler = LazyOptional.empty();
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int key) {
            return switch (key) {
                case 0 -> BrickKilnBlockEntity.this.litTime;
                case 1 -> BrickKilnBlockEntity.this.litDuration;
                case 2 -> BrickKilnBlockEntity.this.cookingProgress;
                case 3 -> BrickKilnBlockEntity.this.cookingTotalTime;
                default -> 0;
            };
        }

        public void m_8050_(int key, int value) {
            switch (key) {
                case 0: {
                    BrickKilnBlockEntity.this.litTime = value;
                    break;
                }
                case 1: {
                    BrickKilnBlockEntity.this.litDuration = value;
                    break;
                }
                case 2: {
                    BrickKilnBlockEntity.this.cookingProgress = value;
                    break;
                }
                case 3: {
                    BrickKilnBlockEntity.this.cookingTotalTime = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();

    public BrickKilnBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntityRegistry.BRICK_KILN.get(), blockPos, blockState);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, BrickKilnBlockEntity pBlockEntity) {
        boolean lit = pBlockEntity.isLit();
        boolean changed = false;
        ItemStack fuelItem = pBlockEntity.fuelHandler.getStackInSlot(0);
        ItemStack primaryItem = pBlockEntity.ingredientsHandler.getStackInSlot(0);
        ItemStack secondaryItem = pBlockEntity.ingredientsHandler.getStackInSlot(1);
        ItemStack resultItem = pBlockEntity.resultHandler.getStackInSlot(0);
        CompositeSmeltingRecipe recipe = pLevel.m_7465_().m_44015_((RecipeType)RecipeTypeRegistry.COMPOSITE_SMELTING.get(), (Container)BrickKilnBlockEntity.wrapRecipe(pBlockEntity), pLevel).orElse(null);
        if (pBlockEntity.isLit()) {
            --pBlockEntity.litTime;
        }
        if (recipe != null) {
            pBlockEntity.cookingTotalTime = recipe.getCookingTime();
        }
        if (pBlockEntity.isLit() || !fuelItem.m_41619_() && !primaryItem.m_41619_() && !secondaryItem.m_41619_()) {
            int maxStack = 64;
            if (!pBlockEntity.isLit() && recipe != null && pBlockEntity.canBurn(pLevel, recipe, fuelItem, primaryItem, secondaryItem, resultItem, maxStack)) {
                pBlockEntity.litDuration = pBlockEntity.litTime = ForgeHooks.getBurnTime((ItemStack)fuelItem, (RecipeType)RecipeType.f_44108_);
                if (pBlockEntity.isLit()) {
                    changed = true;
                    fuelItem.m_41774_(1);
                    pBlockEntity.fuelHandler.setStackInSlot(0, fuelItem);
                }
            }
            if (pBlockEntity.isLit() && pBlockEntity.canBurn(pLevel, recipe, fuelItem, primaryItem, secondaryItem, resultItem, maxStack)) {
                ++pBlockEntity.cookingProgress;
                if (pBlockEntity.cookingProgress == pBlockEntity.cookingTotalTime) {
                    pBlockEntity.cookingProgress = 0;
                    pBlockEntity.cookingTotalTime = BrickKilnBlockEntity.getTotalCookTime(pLevel, pBlockEntity);
                    if (pBlockEntity.burn(pLevel, recipe, pBlockEntity, fuelItem, primaryItem, secondaryItem, resultItem, maxStack)) {
                        pBlockEntity.m_6029_(recipe);
                    }
                    changed = true;
                }
            } else {
                pBlockEntity.cookingProgress = 0;
            }
        } else if (!pBlockEntity.isLit() && pBlockEntity.cookingProgress > 0) {
            pBlockEntity.cookingProgress = Mth.m_14045_((int)(pBlockEntity.cookingProgress - 2), (int)0, (int)pBlockEntity.cookingTotalTime);
        }
        if (lit != pBlockEntity.isLit()) {
            changed = true;
            pState = (BlockState)pState.m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(pBlockEntity.isLit()));
            pLevel.m_7731_(pPos, pState, 3);
        }
        if (changed) {
            BrickKilnBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    private boolean canBurn(Level level, @Nullable Recipe<Container> pRecipe, ItemStack fuel, ItemStack primary, ItemStack secondary, ItemStack resultPrev, int maxStackSize) {
        if (!primary.m_41619_() && !secondary.m_41619_() && pRecipe != null) {
            ItemStack result = pRecipe.m_5874_((Container)new SimpleContainer(new ItemStack[]{primary, secondary}), level.m_9598_());
            if (result.m_41619_()) {
                return false;
            }
            if (resultPrev.m_41619_()) {
                return true;
            }
            if (!resultPrev.equals(result)) {
                return false;
            }
            if (resultPrev.m_41613_() + result.m_41613_() <= maxStackSize && resultPrev.m_41613_() + result.m_41613_() <= resultPrev.m_41741_()) {
                return true;
            }
            return resultPrev.m_41613_() + result.m_41613_() <= result.m_41741_();
        }
        return false;
    }

    private boolean burn(Level level, Recipe<Container> pRecipe, BrickKilnBlockEntity entity, ItemStack fuel, ItemStack primary, ItemStack secondary, ItemStack resultPrev, int maxStackSize) {
        if (this.canBurn(level, pRecipe, fuel, primary, secondary, resultPrev, maxStackSize)) {
            ItemStack newResult = pRecipe.m_5874_((Container)new SimpleContainer(new ItemStack[]{primary, secondary}), level.m_9598_());
            if (resultPrev.m_41619_()) {
                entity.resultHandler.setStackInSlot(0, newResult.m_41777_());
            } else if (resultPrev.m_150930_(newResult.m_41720_())) {
                resultPrev.m_41769_(newResult.m_41613_());
            }
            primary.m_41774_(1);
            secondary.m_41774_(1);
            entity.ingredientsHandler.setStackInSlot(0, primary);
            entity.ingredientsHandler.setStackInSlot(1, secondary);
            return true;
        }
        return false;
    }

    private static int getTotalCookTime(Level pLevel, BrickKilnBlockEntity entity) {
        return pLevel.m_7465_().m_44015_((RecipeType)RecipeTypeRegistry.COMPOSITE_SMELTING.get(), (Container)BrickKilnBlockEntity.wrapRecipe(entity), pLevel).map(CompositeSmeltingRecipe::getCookingTime).orElse(200);
    }

    public void m_6029_(@Nullable Recipe<?> pRecipe) {
        if (pRecipe != null) {
            ResourceLocation resourcelocation = pRecipe.m_6423_();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void awardUsedRecipes(Player pPlayer) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer pPlayer) {
        List<Recipe<?>> list = this.getRecipesToAwardAndPopExperience(pPlayer.m_284548_(), pPlayer.m_20182_());
        pPlayer.m_7281_(list);
        this.recipesUsed.clear();
    }

    public List<Recipe<?>> getRecipesToAwardAndPopExperience(ServerLevel pLevel, Vec3 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            pLevel.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(p_155023_ -> {
                list.add(p_155023_);
                BrickKilnBlockEntity.createExperience(pLevel, pos, entry.getIntValue(), ((AbstractCookingRecipe)p_155023_).m_43750_());
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel pLevel, Vec3 p_155000_, int p_155001_, float p_155002_) {
        int i = Mth.m_14143_((float)((float)p_155001_ * p_155002_));
        float f = Mth.m_14187_((float)((float)p_155001_ * p_155002_));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.m_147082_((ServerLevel)pLevel, (Vec3)p_155000_, (int)i);
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    public Component m_5446_() {
        return CONTAINER_TITLE;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new BrickKilnMenu(pContainerId, this.f_58858_, pInventory, (IItemHandler)this.wrapHandlers(), this.dataAccess);
    }

    public CombinedInvWrapper wrapHandlers() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.ingredientsHandler, this.fuelHandler, this.resultHandler});
    }

    private static RecipeWrapper wrapRecipe(BrickKilnBlockEntity entity) {
        return new RecipeWrapper((IItemHandlerModifiable)entity.ingredientsHandler);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.litTime = pTag.m_128451_("BurnTime");
        this.cookingProgress = pTag.m_128451_("CookTime");
        this.cookingTotalTime = pTag.m_128451_("CookTimeTotal");
        ListTag itemListTag = pTag.m_128437_("Items", 10);
        block6: for (int i = 0; i < itemListTag.size(); ++i) {
            CompoundTag itemTag = itemListTag.m_128728_(i);
            int j = itemTag.m_128445_("Slot") & 0xFF;
            switch (j) {
                case 0: {
                    this.ingredientsHandler.setStackInSlot(0, ItemStack.m_41712_((CompoundTag)itemTag));
                    continue block6;
                }
                case 1: {
                    this.ingredientsHandler.setStackInSlot(1, ItemStack.m_41712_((CompoundTag)itemTag));
                    continue block6;
                }
                case 2: {
                    this.fuelHandler.setStackInSlot(0, ItemStack.m_41712_((CompoundTag)itemTag));
                    continue block6;
                }
                case 3: {
                    this.resultHandler.setStackInSlot(0, ItemStack.m_41712_((CompoundTag)itemTag));
                }
            }
        }
        this.litDuration = ForgeHooks.getBurnTime((ItemStack)this.fuelHandler.getStackInSlot(0), (RecipeType)RecipeType.f_44108_);
        CompoundTag recipesTag = pTag.m_128469_("RecipesUsed");
        for (String s : recipesTag.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(s), recipesTag.m_128451_(s));
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("BurnTime", this.litTime);
        pTag.m_128405_("CookTime", this.cookingProgress);
        pTag.m_128405_("CookTimeTotal", this.cookingTotalTime);
        ListTag itemListTag = new ListTag();
        CombinedInvWrapper items = this.wrapHandlers();
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack item = items.getStackInSlot(i);
            if (item.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128344_("Slot", (byte)i);
            item.m_41739_(itemTag);
            itemListTag.add((Object)itemTag);
        }
        if (!itemListTag.isEmpty()) {
            pTag.m_128365_("Items", (Tag)itemListTag);
        }
        CompoundTag recipesTag = new CompoundTag();
        this.recipesUsed.forEach((resourceLocation, count) -> recipesTag.m_128405_(resourceLocation.toString(), count.intValue()));
        pTag.m_128365_("RecipesUsed", (Tag)recipesTag);
    }

    public void onLoad() {
        super.onLoad();
        this.createLazyHandlers();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.ingredientsLazyHandler.cast();
            }
            if (facing == Direction.DOWN) {
                return this.resultLazyHandler.cast();
            }
            return this.fuelLazyHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.ingredientsLazyHandler.invalidate();
        this.resultLazyHandler.invalidate();
        this.fuelLazyHandler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.createLazyHandlers();
    }

    private void createLazyHandlers() {
        this.ingredientsLazyHandler = LazyOptional.of(() -> this.ingredientsHandler);
        this.resultLazyHandler = LazyOptional.of(() -> this.resultHandler);
        this.fuelLazyHandler = LazyOptional.of(() -> this.fuelHandler);
    }
}

